%This script will plot the action potential, the changes in the m,h,n
%gates and the external current applied

%Store the arrays for future plotting:
time=I_V.time;
Iext=I_V.signals.values(:,1);
V=I_V.signals.values(:,2);

m=mhn(:,1);
h=mhn(:,2);
n=mhn(:,3);

%Plot Results
figure(1)
subplot(3,1,1), plot(time,V);
title('Voltage vs Time');
ylabel('Membrane Voltage (mv)');
xlabel('Time (ms)');
subplot(3,1,2), plot(time,m,time,h,time,n);
title('MHN gates vs Time');
ylabel('MHN gates');
xlabel('Time (ms)');
legend('M gates','H gates', 'N gates');
subplot(3,1,3), plot(time,Iext);
title('External Current vs Time');
ylabel('External Current (muA)');
xlabel('Time (ms)');